function keyprops_w_index=calculatecantileversnumbers
% Calculates the thermal oscillation parameters for the first mode of rectangular cantilevers with
% any number of combinations of material and size parameters.
% These can be saved to an ascii file. 
% help: just follow the instructions
% uses: SaderCalcProps.m

disp('Give parameters:')
disp('syntax: "15" or "[10, 13, 20,]" or "10:1:20" ');
L   =1e-6*input('length                 (microns):      ');
W   =1e-6*input('width                  (microns):      ');
t1  =1e-9*input('thickness bottom layer (NANOm)  :      ');
E1  =1e9 *input('E bot. layer           (Gpa)    :      ');
rho1=     input('rho bot. layer         (kg/m^3) :      ');
t2  =1e-9*input('thickness top layer    (NANOm  ):      ');
E2  =1e9 *input('E top layer            (Gpa)    :      ');
rho2=     input('rho top layer          (kg/m^3) :      ');

ii=0;
for aa=1:length(L)
    for bb=1:length(W)
        for cc=1:length(t1)
            for dd=1:length(E1)
                for ee=1:length(rho1)
                    for ff=1:length(t2)
                        for gg=1:length(E2)
                            for hh=1:length(rho2)
                                ii=ii+1;
                                params=[L(aa),W(bb),t1(cc),E1(dd),rho1(ee),t2(ff),E2(gg),rho2(hh)];
                                keyprops=SaderCalcProps([L(aa),W(bb),t1(cc),E1(dd),rho1(ee),t2(ff),E2(gg),rho2(hh)]);
                                keyprops_w_index(ii,:)=[params,keyprops];
                            end
                        end
                    end
                end
            end
        end
    end
end
saver=input('Save this? (y=yes, anything else=no)  : ','s');
if strcmpi(saver,'y')==1 
   flnm=input('Filename? : ','s');
   append=input('Append to existing file, if applicable? (n=create or overwrite, anything else=append)','s');
    if strcmpi(append,'n')==1 
        fid = fopen(flnm,'w');
        fprintf(fid,'length, width, thick_1, Youngs_1, dens_1, thick_2, Youngs_2, dens_2, spring_cons, F_air, F_water, Q _air, Q_water, Fnoise_a, Fnoise_w \n');                            
        fprintf(fid,'%12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e\n',keyprops_w_index');
        fclose(fid)
    else 
        fid = fopen(flnm,'a');
        fprintf(fid,'%12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e, %12.6e\n',keyprops_w_index');
        fclose(fid)
    end
else
    disp('outcome discarded')
end
    
            